//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Drawing.Printing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;
using System.IO;

namespace WindowsForms
{
	/// <summary>
	/// Podsumowanie dla windowsForm.
	/// </summary>
	public class windowsForm : System.Windows.Forms.Form
	{
		const string PRINTER = @"\\Whiteout\HP LaserJet 4000 PCL 6";
		const string RTFPATH = @"SampleText.rtf";

		private System.Windows.Forms.StatusBar statusBar;
		private System.Windows.Forms.NotifyIcon notifyIcon;
		private System.Windows.Forms.StatusBarPanel statusBarPanel1;
		private System.Windows.Forms.StatusBarPanel statusBarPanel2;
		private System.Windows.Forms.StatusBarPanel statusBarPanel3;
		private System.Windows.Forms.Button pageSetup;
		private System.Windows.Forms.GroupBox dialogGroup;
		private System.Windows.Forms.PageSetupDialog pageSetupDialog;
		private System.Windows.Forms.PrintPreviewDialog printPreviewDialog;
		private System.Windows.Forms.Button printPreview;
		private System.ComponentModel.IContainer components;
		private StreamReader streamToPrint;
		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.ColorDialog colorDialog;
		private System.Windows.Forms.Button colorButton;
		private System.Windows.Forms.FontDialog fontDialog;
		private System.Windows.Forms.Button fontButton;
		private System.Windows.Forms.Button openFileButton;
		private System.Windows.Forms.Timer timer;
		private System.Windows.Forms.ToolBar toolBar;
		private System.Windows.Forms.ToolBarButton toolbarPageSetup;
		private System.Windows.Forms.ToolBarButton toolBarPrintPreview;
		private System.Windows.Forms.ToolBarButton toolBarColorDialog;
		private System.Windows.Forms.ToolBarButton toolBarFontDialog;
		private System.Windows.Forms.ToolBarButton toolBarOpenFile;
		private System.Windows.Forms.ImageList toolBarImageList;
		private System.Windows.Forms.ContextMenu contextMenu;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.ToolTip toolTip;
		private System.Windows.Forms.HelpProvider helpProvider;
		private System.Windows.Forms.RichTextBox richTextBox;
		private System.Windows.Forms.TrackBar trackBar;
		private System.Windows.Forms.TextBox trackBarValue;
		private System.Windows.Forms.NumericUpDown numericUpDown;
		private System.Windows.Forms.DomainUpDown domainUpDown;
		private System.Windows.Forms.MonthCalendar monthCalendar;
		private System.Windows.Forms.DateTimePicker dateTimePicker;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton redRadioButton;
		private System.Windows.Forms.RadioButton greenRadioButton;
		private System.Windows.Forms.RadioButton blueRadioButton;
		private System.Windows.Forms.Panel panel;
		private System.Windows.Forms.LinkLabel samsLinkLabel;
		private System.Windows.Forms.LinkLabel microsoftLinkLabel;
		private System.Windows.Forms.LinkLabel gotdotnetLinkLabel;
		private System.Windows.Forms.LinkLabel msdnLinkLabel;
		private System.Windows.Forms.ListView listView;
		private System.Windows.Forms.ImageList listviewImageList;
		private System.Windows.Forms.ContextMenu processContextMenu;
		private Font printFont;

		public windowsForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
			DateTime now = DateTime.Now;
			statusBarPanel2.Text = now.ToShortDateString();
			statusBarPanel3.Text = now.ToShortTimeString();
			timer.Enabled = true;
			richTextBox.LoadFile(RTFPATH, RichTextBoxStreamType.RichText);
			// Utworzenie nowego cza przy uyciu metody Add klasy LinkCollection.
			samsLinkLabel.Links.Add(0,5,"http://www.samspublishing.com/");
			microsoftLinkLabel.Links.Add(0,9,"http://www.microsoft.com/");
			msdnLinkLabel.Links.Add(0,4,"http://msdn.microsoft.com/");
			gotdotnetLinkLabel.Links.Add(0,9,"http://www.gotdotnet.com/");

			Process [] pa = Process.GetProcesses();
			foreach(Process p in pa)
			{
				ListViewItem item = listView.Items.Add(p.ProcessName,0);
				item.Tag = p;
			}
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(windowsForm));
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel2 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel3 = new System.Windows.Forms.StatusBarPanel();
			this.notifyIcon = new System.Windows.Forms.NotifyIcon(this.components);
			this.pageSetup = new System.Windows.Forms.Button();
			this.dialogGroup = new System.Windows.Forms.GroupBox();
			this.openFileButton = new System.Windows.Forms.Button();
			this.fontButton = new System.Windows.Forms.Button();
			this.colorButton = new System.Windows.Forms.Button();
			this.printPreview = new System.Windows.Forms.Button();
			this.pageSetupDialog = new System.Windows.Forms.PageSetupDialog();
			this.printPreviewDialog = new System.Windows.Forms.PrintPreviewDialog();
			this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.colorDialog = new System.Windows.Forms.ColorDialog();
			this.fontDialog = new System.Windows.Forms.FontDialog();
			this.timer = new System.Windows.Forms.Timer(this.components);
			this.toolBar = new System.Windows.Forms.ToolBar();
			this.toolbarPageSetup = new System.Windows.Forms.ToolBarButton();
			this.toolBarPrintPreview = new System.Windows.Forms.ToolBarButton();
			this.toolBarColorDialog = new System.Windows.Forms.ToolBarButton();
			this.toolBarFontDialog = new System.Windows.Forms.ToolBarButton();
			this.toolBarOpenFile = new System.Windows.Forms.ToolBarButton();
			this.toolBarImageList = new System.Windows.Forms.ImageList(this.components);
			this.contextMenu = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.toolTip = new System.Windows.Forms.ToolTip(this.components);
			this.trackBar = new System.Windows.Forms.TrackBar();
			this.trackBarValue = new System.Windows.Forms.TextBox();
			this.numericUpDown = new System.Windows.Forms.NumericUpDown();
			this.domainUpDown = new System.Windows.Forms.DomainUpDown();
			this.helpProvider = new System.Windows.Forms.HelpProvider();
			this.richTextBox = new System.Windows.Forms.RichTextBox();
			this.monthCalendar = new System.Windows.Forms.MonthCalendar();
			this.dateTimePicker = new System.Windows.Forms.DateTimePicker();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.panel = new System.Windows.Forms.Panel();
			this.blueRadioButton = new System.Windows.Forms.RadioButton();
			this.greenRadioButton = new System.Windows.Forms.RadioButton();
			this.redRadioButton = new System.Windows.Forms.RadioButton();
			this.samsLinkLabel = new System.Windows.Forms.LinkLabel();
			this.microsoftLinkLabel = new System.Windows.Forms.LinkLabel();
			this.gotdotnetLinkLabel = new System.Windows.Forms.LinkLabel();
			this.msdnLinkLabel = new System.Windows.Forms.LinkLabel();
			this.listView = new System.Windows.Forms.ListView();
			this.processContextMenu = new System.Windows.Forms.ContextMenu();
			this.listviewImageList = new System.Windows.Forms.ImageList(this.components);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel3)).BeginInit();
			this.dialogGroup.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.trackBar)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 428);
			this.statusBar.Name = "statusBar";
			this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						 this.statusBarPanel1,
																						 this.statusBarPanel2,
																						 this.statusBarPanel3});
			this.statusBar.ShowPanels = true;
			this.statusBar.Size = new System.Drawing.Size(860, 29);
			this.statusBar.TabIndex = 0;
			// 
			// statusBarPanel1
			// 
			this.statusBarPanel1.Text = "Status";
			this.statusBarPanel1.ToolTipText = "Informacje o statusie";
			this.statusBarPanel1.Width = 480;
			// 
			// statusBarPanel2
			// 
			this.statusBarPanel2.ToolTipText = "Dzisiejsza data";
			this.statusBarPanel2.Width = 65;
			// 
			// statusBarPanel3
			// 
			this.statusBarPanel3.ToolTipText = "Biecy czas";
			this.statusBarPanel3.Width = 65;
			// 
			// notifyIcon
			// 
			this.notifyIcon.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon.Icon")));
			this.notifyIcon.Text = "notifyIcon";
			this.notifyIcon.Visible = true;
			// 
			// pageSetup
			// 
			this.pageSetup.Location = new System.Drawing.Point(9, 28);
			this.pageSetup.Name = "pageSetup";
			this.pageSetup.Size = new System.Drawing.Size(113, 26);
			this.pageSetup.TabIndex = 1;
			this.pageSetup.Text = "Ustawienia strony";
			this.toolTip.SetToolTip(this.pageSetup, "Ustawienia strony do druku");
			this.pageSetup.Click += new System.EventHandler(this.OnPageSetup);
			// 
			// dialogGroup
			// 
			this.dialogGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.openFileButton,
																					  this.fontButton,
																					  this.colorButton,
																					  this.printPreview,
																					  this.pageSetup});
			this.dialogGroup.Location = new System.Drawing.Point(9, 37);
			this.dialogGroup.Name = "dialogGroup";
			this.dialogGroup.Size = new System.Drawing.Size(132, 225);
			this.dialogGroup.TabIndex = 2;
			this.dialogGroup.TabStop = false;
			this.dialogGroup.Text = "Okna dialogowe";
			this.toolTip.SetToolTip(this.dialogGroup, "Wygenerowane przez system okna dialogowe.");
			// 
			// openFileButton
			// 
			this.openFileButton.Location = new System.Drawing.Point(9, 178);
			this.openFileButton.Name = "openFileButton";
			this.openFileButton.Size = new System.Drawing.Size(113, 27);
			this.openFileButton.TabIndex = 5;
			this.openFileButton.Text = "Otwrz plik";
			this.toolTip.SetToolTip(this.openFileButton, "Otwiera plik");
			this.openFileButton.Click += new System.EventHandler(this.OnOpenFile);
			// 
			// fontButton
			// 
			this.fontButton.Location = new System.Drawing.Point(9, 141);
			this.fontButton.Name = "fontButton";
			this.fontButton.Size = new System.Drawing.Size(113, 26);
			this.fontButton.TabIndex = 4;
			this.fontButton.Text = "Okno dialogowe Czcionki";
			this.toolTip.SetToolTip(this.fontButton, "Okno dialogowe Czcionki");
			this.fontButton.Click += new System.EventHandler(this.OnFontDialog);
			// 
			// colorButton
			// 
			this.colorButton.Location = new System.Drawing.Point(9, 102);
			this.colorButton.Name = "colorButton";
			this.colorButton.Size = new System.Drawing.Size(113, 28);
			this.colorButton.TabIndex = 3;
			this.colorButton.Text = "Okno dialogowe Kolor";
			this.toolTip.SetToolTip(this.colorButton, "Okno dialogowe Kolor");
			this.colorButton.Click += new System.EventHandler(this.OnColorDialog);
			// 
			// printPreview
			// 
			this.printPreview.Location = new System.Drawing.Point(9, 65);
			this.printPreview.Name = "printPreview";
			this.printPreview.Size = new System.Drawing.Size(113, 28);
			this.printPreview.TabIndex = 2;
			this.printPreview.Text = "Podgld wydruku";
			this.toolTip.SetToolTip(this.printPreview, "Podgld wydruku");
			this.printPreview.Click += new System.EventHandler(this.OnPrintPreview);
			// 
			// printPreviewDialog
			// 
			this.printPreviewDialog.AutoScrollMargin = new System.Drawing.Size(0, 0);
			this.printPreviewDialog.AutoScrollMinSize = new System.Drawing.Size(0, 0);
			this.printPreviewDialog.ClientSize = new System.Drawing.Size(400, 300);
			this.printPreviewDialog.Enabled = true;
			this.printPreviewDialog.Icon = ((System.Drawing.Icon)(resources.GetObject("printPreviewDialog.Icon")));
			this.printPreviewDialog.Location = new System.Drawing.Point(266, 15);
			this.printPreviewDialog.MaximumSize = new System.Drawing.Size(0, 0);
			this.printPreviewDialog.Name = "printPreviewDialog";
			this.printPreviewDialog.Opacity = 1;
			this.printPreviewDialog.TransparencyKey = System.Drawing.Color.Empty;
			this.printPreviewDialog.Visible = false;
			// 
			// timer
			// 
			this.timer.Interval = 30000;
			this.timer.Tick += new System.EventHandler(this.OnTimer);
			// 
			// toolBar
			// 
			this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																					   this.toolbarPageSetup,
																					   this.toolBarPrintPreview,
																					   this.toolBarColorDialog,
																					   this.toolBarFontDialog,
																					   this.toolBarOpenFile});
			this.toolBar.DropDownArrows = true;
			this.toolBar.ImageList = this.toolBarImageList;
			this.toolBar.Name = "toolBar";
			this.toolBar.ShowToolTips = true;
			this.toolBar.Size = new System.Drawing.Size(860, 25);
			this.toolBar.TabIndex = 3;
			this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.OnToolBarButtonClick);
			// 
			// toolbarPageSetup
			// 
			this.toolbarPageSetup.ImageIndex = 0;
			this.toolbarPageSetup.ToolTipText = "Wywouje ustawienia drukowanej strony";
			// 
			// toolBarPrintPreview
			// 
			this.toolBarPrintPreview.ImageIndex = 1;
			this.toolBarPrintPreview.ToolTipText = "Okno dialogowe podgldu wydruku";
			// 
			// toolBarColorDialog
			// 
			this.toolBarColorDialog.ImageIndex = 2;
			this.toolBarColorDialog.ToolTipText = "Okno dialogowe Kolor";
			// 
			// toolBarFontDialog
			// 
			this.toolBarFontDialog.ImageIndex = 3;
			this.toolBarFontDialog.ToolTipText = "Okno dialogowe Czcionki";
			// 
			// toolBarOpenFile
			// 
			this.toolBarOpenFile.ImageIndex = 4;
			this.toolBarOpenFile.ToolTipText = "Okno dialogowe Otwrz";
			// 
			// toolBarImageList
			// 
			this.toolBarImageList.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit;
			this.toolBarImageList.ImageSize = new System.Drawing.Size(16, 16);
			this.toolBarImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("toolBarImageList.ImageStream")));
			this.toolBarImageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// contextMenu
			// 
			this.contextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.menuItem1,
																						this.menuItem2,
																						this.menuItem3,
																						this.menuItem4,
																						this.menuItem5});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.Text = "Ustawienia strony";
			this.menuItem1.Click += new System.EventHandler(this.OnPageSetup);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "Podgld wydruku";
			this.menuItem2.Click += new System.EventHandler(this.OnPrintPreview);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 2;
			this.menuItem3.Text = "Okno dialogowe Kolor";
			this.menuItem3.Click += new System.EventHandler(this.OnColorDialog);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 3;
			this.menuItem4.Text = "Okno dialogowe Czcionki";
			this.menuItem4.Click += new System.EventHandler(this.OnFontDialog);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 4;
			this.menuItem5.Text = "Otwrz plik";
			this.menuItem5.Click += new System.EventHandler(this.OnOpenFile);
			// 
			// trackBar
			// 
			this.trackBar.Location = new System.Drawing.Point(150, 186);
			this.trackBar.Name = "trackBar";
			this.trackBar.Size = new System.Drawing.Size(121, 56);
			this.trackBar.TabIndex = 5;
			this.toolTip.SetToolTip(this.trackBar, "Pasek ledzenia");
			this.trackBar.Scroll += new System.EventHandler(this.OnTrackScroll);
			// 
			// trackBarValue
			// 
			this.trackBarValue.Location = new System.Drawing.Point(159, 252);
			this.trackBarValue.Name = "trackBarValue";
			this.trackBarValue.ReadOnly = true;
			this.trackBarValue.Size = new System.Drawing.Size(37, 22);
			this.trackBarValue.TabIndex = 6;
			this.trackBarValue.Text = "";
			this.toolTip.SetToolTip(this.trackBarValue, "Warto paska ledzenia.");
			// 
			// numericUpDown
			// 
			this.numericUpDown.Location = new System.Drawing.Point(206, 252);
			this.numericUpDown.Name = "numericUpDown";
			this.numericUpDown.Size = new System.Drawing.Size(46, 22);
			this.numericUpDown.TabIndex = 7;
			this.toolTip.SetToolTip(this.numericUpDown, "Sterowanie gra/d");
			this.numericUpDown.ValueChanged += new System.EventHandler(this.OnNumericUpDown);
			// 
			// domainUpDown
			// 
			this.domainUpDown.Items.Add("Ustawienia strony");
			this.domainUpDown.Items.Add("Podgld wydruku");
			this.domainUpDown.Items.Add("Okno dialogowe Kolor");
			this.domainUpDown.Items.Add("Okno dialogowe Czcionki");
			this.domainUpDown.Items.Add("Otwrz plik");
			this.domainUpDown.Location = new System.Drawing.Point(9, 271);
			this.domainUpDown.Name = "domainUpDown";
			this.domainUpDown.Size = new System.Drawing.Size(122, 22);
			this.domainUpDown.TabIndex = 8;
			this.toolTip.SetToolTip(this.domainUpDown, "Przewinicie listy okien dialogowych w gr lub w d.");
			this.domainUpDown.SelectedItemChanged += new System.EventHandler(this.OnUpDownSelection);
			// 
			// helpProvider
			// 
			this.helpProvider.HelpNamespace = "F:\\CLR Book\\AppDomain\\Library\\WindowsForms\\HTMLHelpPage.htm";
			// 
			// richTextBox
			// 
			this.richTextBox.Location = new System.Drawing.Point(150, 47);
			this.richTextBox.Name = "richTextBox";
			this.richTextBox.Size = new System.Drawing.Size(411, 121);
			this.richTextBox.TabIndex = 4;
			this.richTextBox.Text = "";
			// 
			// monthCalendar
			// 
			this.monthCalendar.Location = new System.Drawing.Point(280, 178);
			this.monthCalendar.Name = "monthCalendar";
			this.monthCalendar.TabIndex = 9;
			this.monthCalendar.DateSelected += new System.Windows.Forms.DateRangeEventHandler(this.OnDateSelect);
			// 
			// dateTimePicker
			// 
			this.dateTimePicker.Location = new System.Drawing.Point(280, 402);
			this.dateTimePicker.Name = "dateTimePicker";
			this.dateTimePicker.Size = new System.Drawing.Size(281, 22);
			this.dateTimePicker.TabIndex = 10;
			this.dateTimePicker.ValueChanged += new System.EventHandler(this.OnDateTimeSelect);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.panel,
																					this.blueRadioButton,
																					this.greenRadioButton,
																					this.redRadioButton});
			this.groupBox1.Location = new System.Drawing.Point(141, 299);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(130, 122);
			this.groupBox1.TabIndex = 11;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Przyciski opcji";
			// 
			// panel
			// 
			this.panel.Location = new System.Drawing.Point(84, 28);
			this.panel.Name = "panel";
			this.panel.Size = new System.Drawing.Size(38, 84);
			this.panel.TabIndex = 3;
			// 
			// blueRadioButton
			// 
			this.blueRadioButton.Location = new System.Drawing.Point(9, 84);
			this.blueRadioButton.Name = "blueRadioButton";
			this.blueRadioButton.Size = new System.Drawing.Size(75, 28);
			this.blueRadioButton.TabIndex = 2;
			this.blueRadioButton.Text = "Niebieski";
			this.blueRadioButton.Click += new System.EventHandler(this.OnColorRadioButton);
			// 
			// greenRadioButton
			// 
			this.greenRadioButton.Location = new System.Drawing.Point(9, 56);
			this.greenRadioButton.Name = "greenRadioButton";
			this.greenRadioButton.Size = new System.Drawing.Size(75, 28);
			this.greenRadioButton.TabIndex = 1;
			this.greenRadioButton.Text = "Zielony";
			this.greenRadioButton.Click += new System.EventHandler(this.OnColorRadioButton);
			// 
			// redRadioButton
			// 
			this.redRadioButton.Location = new System.Drawing.Point(9, 28);
			this.redRadioButton.Name = "redRadioButton";
			this.redRadioButton.Size = new System.Drawing.Size(75, 28);
			this.redRadioButton.TabIndex = 0;
			this.redRadioButton.Text = "Czerwony";
			this.redRadioButton.Click += new System.EventHandler(this.OnColorRadioButton);
			// 
			// samsLinkLabel
			// 
			this.samsLinkLabel.Location = new System.Drawing.Point(9, 308);
			this.samsLinkLabel.Name = "samsLinkLabel";
			this.samsLinkLabel.Size = new System.Drawing.Size(65, 28);
			this.samsLinkLabel.TabIndex = 12;
			this.samsLinkLabel.TabStop = true;
			this.samsLinkLabel.Text = "Sam\'s";
			this.samsLinkLabel.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.OnLinkClicked);
			// 
			// microsoftLinkLabel
			// 
			this.microsoftLinkLabel.Location = new System.Drawing.Point(9, 337);
			this.microsoftLinkLabel.Name = "microsoftLinkLabel";
			this.microsoftLinkLabel.Size = new System.Drawing.Size(84, 26);
			this.microsoftLinkLabel.TabIndex = 13;
			this.microsoftLinkLabel.TabStop = true;
			this.microsoftLinkLabel.Text = "Microsoft";
			this.microsoftLinkLabel.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.OnLinkClicked);
			// 
			// gotdotnetLinkLabel
			// 
			this.gotdotnetLinkLabel.Location = new System.Drawing.Point(9, 392);
			this.gotdotnetLinkLabel.Name = "gotdotnetLinkLabel";
			this.gotdotnetLinkLabel.Size = new System.Drawing.Size(84, 28);
			this.gotdotnetLinkLabel.TabIndex = 14;
			this.gotdotnetLinkLabel.TabStop = true;
			this.gotdotnetLinkLabel.Text = "GotDotNet";
			this.gotdotnetLinkLabel.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.OnLinkClicked);
			// 
			// msdnLinkLabel
			// 
			this.msdnLinkLabel.Location = new System.Drawing.Point(9, 364);
			this.msdnLinkLabel.Name = "msdnLinkLabel";
			this.msdnLinkLabel.Size = new System.Drawing.Size(84, 27);
			this.msdnLinkLabel.TabIndex = 15;
			this.msdnLinkLabel.TabStop = true;
			this.msdnLinkLabel.Text = "MSDN";
			this.msdnLinkLabel.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.OnLinkClicked);
			// 
			// listView
			// 
			this.listView.ContextMenu = this.processContextMenu;
			this.listView.FullRowSelect = true;
			this.listView.HoverSelection = true;
			this.listView.Location = new System.Drawing.Point(571, 47);
			this.listView.MultiSelect = false;
			this.listView.Name = "listView";
			this.listView.Size = new System.Drawing.Size(280, 374);
			this.listView.SmallImageList = this.listviewImageList;
			this.listView.TabIndex = 16;
			this.listView.View = System.Windows.Forms.View.SmallIcon;
			this.listView.DoubleClick += new System.EventHandler(this.OnListViewDoubleClick);
			// 
			// processContextMenu
			// 
			this.processContextMenu.Popup += new System.EventHandler(this.OnProcessMenuPopup);
			// 
			// listviewImageList
			// 
			this.listviewImageList.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit;
			this.listviewImageList.ImageSize = new System.Drawing.Size(16, 16);
			this.listviewImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("listviewImageList.ImageStream")));
			this.listviewImageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// windowsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(860, 457);
			this.ContextMenu = this.contextMenu;
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.listView,
																		  this.msdnLinkLabel,
																		  this.gotdotnetLinkLabel,
																		  this.microsoftLinkLabel,
																		  this.samsLinkLabel,
																		  this.groupBox1,
																		  this.dateTimePicker,
																		  this.monthCalendar,
																		  this.domainUpDown,
																		  this.numericUpDown,
																		  this.trackBarValue,
																		  this.trackBar,
																		  this.richTextBox,
																		  this.toolBar,
																		  this.dialogGroup,
																		  this.statusBar});
			this.helpProvider.SetHelpKeyword(this, "Form");
			this.helpProvider.SetHelpString(this, "Form");
			this.Name = "windowsForm";
			this.helpProvider.SetShowHelp(this, true);
			this.Text = "Przykad elementu sterujcego";
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel3)).EndInit();
			this.dialogGroup.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.trackBar)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new windowsForm());
		}

		// Zdarzenie PrintPage jest zgaszane dla kadej drukowanej strony.
		private void OnPrintPage(object sender, PrintPageEventArgs ev) 
		{
			float linesPerPage = 0;
			float yPos = 0;
			int count = 0;
			float leftMargin = ev.MarginBounds.Left;
			float topMargin = ev.MarginBounds.Top;
			string line = null;

			// Obliczenie liczby wierszy na stronie.
			linesPerPage = ev.MarginBounds.Height / 
				printFont.GetHeight(ev.Graphics);

			// Wydrukowanie poszczeglnych wierszy pliku.
			while(count < linesPerPage && 
				((line=streamToPrint.ReadLine()) != null)) 
			{
				yPos = topMargin + (count * 
					printFont.GetHeight(ev.Graphics));
				ev.Graphics.DrawString(line, printFont, Brushes.Black, 
					leftMargin, yPos, new StringFormat());
				count++;
			}

			// Jeli istniej dodatkowe wiersze, naley wydrukowa kolejn stron.
			if(line != null)
				ev.HasMorePages = true;
			else
				ev.HasMorePages = false;
		}

		private void OnPageSetup(object sender, System.EventArgs e)
		{
			streamToPrint = new StreamReader("WindowsForm.cs");
			printFont = new Font("Arial", 10);
			PrintDocument pd = new PrintDocument();
			pd.PrinterSettings.PrinterName = PRINTER;
			pd.PrintPage += new PrintPageEventHandler(this.OnPrintPage);
			pageSetupDialog.Document = pd;
			if(pageSetupDialog.ShowDialog() == DialogResult.OK)
			{
				Debug.WriteLine(string.Format("Page Setup AllowMargins: {0}", pageSetupDialog.AllowMargins));
				Debug.WriteLine(string.Format("Page Setup AllowOrientation: {0}", pageSetupDialog.AllowOrientation));
				Debug.WriteLine(string.Format("Page Setup AllowPaper: {0}", pageSetupDialog.AllowPaper));
				Debug.WriteLine(string.Format("Page Setup AllowPrinter: {0}", pageSetupDialog.AllowPrinter));
				Debug.WriteLine(string.Format("Page Setup MinMargins: {0}", pageSetupDialog.MinMargins));
				Debug.WriteLine(string.Format("Page Setup PageSettings: {0}", pageSetupDialog.PageSettings));
				Debug.WriteLine(string.Format("Page Setup PrinterSettings: {0}", pageSetupDialog.PrinterSettings));
				Debug.WriteLine(string.Format("Page Setup ShowHelp: {0}", pageSetupDialog.ShowHelp));
				Debug.WriteLine(string.Format("Page Setup ShowNetwork: {0}", pageSetupDialog.ShowNetwork));
			}
		}

		private void OnPrintPreview(object sender, System.EventArgs e)
		{
			if(openFileDialog.ShowDialog() == DialogResult.OK)
			{
				streamToPrint = new StreamReader(openFileDialog.FileName);
				printFont = new Font("Arial", 10);

				PrintDocument pd = new PrintDocument();
				pd.PrinterSettings.PrinterName = PRINTER;
				pd.DocumentName = "Test Print Page";
				pd.PrintPage += new PrintPageEventHandler(this.OnPrintPage);
				printPreviewDialog.Document = pd;
				printPreviewDialog.ShowDialog();
			}
		}

		private void OnColorDialog(object sender, System.EventArgs e)
		{
			if(colorDialog.ShowDialog() == DialogResult.OK)
			{
				statusBarPanel1.Text = colorDialog.Color.ToString();
			}
		}

		private void OnFontDialog(object sender, System.EventArgs e)
		{
			if(fontDialog.ShowDialog() == DialogResult.OK)
				statusBarPanel1.Text = fontDialog.Font.ToString();
		}

		private void OnOpenFile(object sender, System.EventArgs e)
		{
			if(openFileDialog.ShowDialog() == DialogResult.OK)
				statusBarPanel1.Text = openFileDialog.FileName;
		}

		private void OnTimer(object sender, System.EventArgs e)
		{
			DateTime now = DateTime.Now;
			statusBarPanel2.Text = now.ToShortDateString();
			statusBarPanel3.Text = now.ToShortTimeString();
		}

		private void OnToolBarButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			switch(e.Button.ImageIndex)
			{
				case 0:
					OnPageSetup(this, new EventArgs());
					break;
				case 1:
					OnPrintPreview(this, new EventArgs());
					break;
				case 2:
					OnColorDialog(this, new EventArgs());
					break;
				case 3:
					OnFontDialog(this, new EventArgs());
					break;
				case 4:
					OnOpenFile(this, new EventArgs());
					break;
			}
		}

		private void OnTrackScroll(object sender, System.EventArgs e)
		{
			trackBarValue.Text = trackBar.Value.ToString();
		}
		private void OnNumericUpDown(object sender, System.EventArgs e)
		{
			trackBarValue.Text = numericUpDown.Value.ToString();
		}
		private void OnUpDownSelection(object sender, System.EventArgs e)
		{
			statusBarPanel1.Text = domainUpDown.SelectedItem.ToString();
		}

		private void OnDateSelect(object sender, System.Windows.Forms.DateRangeEventArgs e)
		{
			statusBarPanel1.Text = string.Format("{0} <-> {1}", e.Start.ToShortDateString(),
				                                                e.End.ToShortDateString());
		}

		private void OnDateTimeSelect(object sender, System.EventArgs e)
		{
			statusBarPanel1.Text = dateTimePicker.Value.ToLongDateString();
		}

		private void OnColorRadioButton(object sender, System.EventArgs e)
		{
			if(redRadioButton.Checked)
			{
				panel.BackColor = Color.Red;
			}
			if(greenRadioButton.Checked)
			{
				panel.BackColor = Color.Green;
			}
			if(blueRadioButton.Checked)
			{
				panel.BackColor = Color.Blue;
			}
		}

		private void OnLinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			System.Diagnostics.Process.Start(e.Link.LinkData.ToString());
		}

		private void OnListViewDoubleClick(object sender, System.EventArgs e)
		{
			ListView.SelectedListViewItemCollection si = listView.SelectedItems;
			foreach(ListViewItem lvi in si)
			{
				try
				{
					ProcessForm form = new ProcessForm();
					form.ProcessName = ((Process)lvi.Tag).ProcessName;
					form.Id = ((Process)lvi.Tag).Id;
					form.BasePriority = ((Process)lvi.Tag).BasePriority;
					form.HandleCount = ((Process)lvi.Tag).HandleCount;
					form.MaxWorkingSet = (int)((Process)lvi.Tag).MaxWorkingSet;
					form.MinWorkingSet = (int)((Process)lvi.Tag).MinWorkingSet;
					form.PeakWorkingSet = ((Process)lvi.Tag).PeakWorkingSet;
					form.WorkingSet = ((Process)lvi.Tag).WorkingSet;
					form.NonpagedSystemMemorySize = ((Process)lvi.Tag).NonpagedSystemMemorySize;
					form.PagedSystemMemorySize = ((Process)lvi.Tag).PagedSystemMemorySize;
					form.PagedMemorySize = ((Process)lvi.Tag).PagedMemorySize;
					form.PeakPagedMemorySize = ((Process)lvi.Tag).PeakPagedMemorySize;
					form.VirtualMemorySize = ((Process)lvi.Tag).VirtualMemorySize;
					form.PeakVirtualMemorySize = ((Process)lvi.Tag).PeakVirtualMemorySize;
					form.StartTime = ((Process)lvi.Tag).StartTime;
					form.UserProcessorTime = ((Process)lvi.Tag).UserProcessorTime;
					form.TotalProcessorTime = ((Process)lvi.Tag).TotalProcessorTime;
					form.Threads = ((Process)lvi.Tag).Threads;
					form.ShowDialog();
				}
				catch(Exception exception)
				{
					Debug.WriteLine(exception);
				}
			}
		}

		private void OnProcessMenuPopup(object sender, System.EventArgs e)
		{
		
		}
	}
}
